unit ChildFrm;

interface

uses Controls, Forms;

type
  TChildForm = class(TForm)
  protected
    procedure Loaded; override;
    procedure CreateParams(var Params: TCreateParams); override;
  end;

implementation

uses WinTypes;

procedure TChildForm.Loaded;
begin
  inherited Loaded;
  Visible := False;
  Position := poDefault;
  BorderIcons := [];
  BorderStyle := bsNone;
  HandleNeeded;
  SetBounds(0, 0, Width, Height);
end;

procedure TChildForm.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do begin
    WndParent := Application.MainForm.Handle;
    Style := WS_CHILD or WS_CLIPSIBLINGS;
    X := 0;
    Y := 0;
  end;
end;

end.
