unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Controls,
  Forms, Dialogs, ExtCtrls, Buttons, StdCtrls, ChildFrm;

type
  TFormMain = class(TForm)
    PanelTop: TPanel;
    PanelMain: TPanel;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure PanelMainEnter(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    FormTypeName: TFormClass;
  public
    { Public declarations }
    ChildFlag: Boolean;
  end;

var
  FormMain:  TFormMain;
  FormChild: TChildForm;

implementation

{$R *.DFM}

uses Child;

{****************************************************************************}
procedure TFormMain.FormCreate(Sender: TObject);
begin
  with FormMain do begin
    Height := 480;                       { Form shrinks 2 pixels without this! }
    Width := 640;                        { Form shrinks 2 pixels without this! }
    AutoScroll := True;                  { Stay! }
  end;
end;

{****************************************************************************}
procedure TFormMain.FormShow(Sender: TObject);
begin
  FormTypeName := TForm2;                { The child form. }
  FormChild := nil;                      { Init. }
  ChildFlag := False;                    { Init. }
  {with PanelMain do
    Caption := Format('Left: %d, Top: %d, Width: %d, Height: %d', [Left, Top, Width, Height]);}
end;

{****************************************************************************}
procedure TFormMain.Button1Click(Sender: TObject);
begin
  Button1.Enabled := False;              { Disable while Child form is up. }
  FormChild := (TForm2.Create(Application) as TChildForm); { Create Child form! }
  {***** NOTE: Take out the line below & it "works" under Delphi 2.01! *****}
  FormChild.Parent := PanelMain;
  with PanelMain do begin
    FormChild.TabOrder := TabOrder;
    FormChild.SetBounds(Left, Top, Width, Height);
  end;
  {***** NOTE: Show method will "work" only if FormChild.Parent note assigned, above. *****}
  FormChild.Show;
  {***** NOTE: --Otherwise, substitute following 2 oddly ordered statements. *****}
{  FormChild.BringToFront;
  FormChild.Visible := True; }
end;

{****************************************************************************}
procedure TFormMain.PanelMainEnter(Sender: TObject);
begin
  if ChildFlag then begin                       { Returning from Child form... }
    ChildFlag := False;                         { Reset switch. }
    Button1.Enabled := True;                    { Re-enable button. }
    FormMain.Caption := 'Main Form';            { Restore caption. }
  end;
end;

{****************************************************************************}
procedure TFormMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
  if FormChild <> nil then begin     { In case user exits app from Child form. }
    FormChild.Close;
    FormChild := nil;
  end;
end;

end.
