{$A+,B-,C+,D+,H+,I+,J-,L+,M-,O+,Q+,R+,T-,U-,V+,W-,X+,Y+}
{$MINSTACKSIZE $00004000}
{$MAXSTACKSIZE $00100000}
{$IMAGEBASE $00400000}
{$APPTYPE Console}
program FileNotify;

{$DEFINE Bug}
{$DEFINE Fix}

uses
  Windows;

{$Z4}
type TWinBool = (winFalse, winTrue);

function FixFindFirstChangeNotification(const lpPathName: PChar;
                                        bWatchSubtree: TWinBool;
                                        dwNotifyFilter: DWORD): THandle stdcall; external kernel32 name 'FindFirstChangeNotificationA';

const
  DirName = 'C:\Pascal';

var
  Handle: THandle;
  RetCode: DWORD;
begin
{$IFDEF Fix}
  Handle := FixFindFirstChangeNotification(DirName,
                                           winTrue,
                                           FILE_NOTIFY_CHANGE_ATTRIBUTES);
{$ELSE}
  Handle := FindFirstChangeNotification(DirName,
                                      {$IFDEF Bug}
                                        True,
                                      {$ELSE}
                                        Bool(Boolean(True)),
                                      {$ENDIF}
                                        FILE_NOTIFY_CHANGE_ATTRIBUTES);
{$ENDIF}
  if Handle = INVALID_HANDLE_VALUE then
    Writeln( 'Error getting notification handle!' )
  else
    try
      RetCode := WaitForSingleObject(Handle,INFINITE);
      case RetCode of
        WAIT_OBJECT_0:  Writeln( 'Wait succeeded!' );
        WAIT_TIMEOUT:   Writeln( 'Timeout!' );
        WAIT_ABANDONED: Writeln( 'Abandoned!' );
      else
        Writeln( 'RetCode = ', RetCode );
      end;
    finally
      FindCloseChangeNotification(Handle)
    end
end.

