unit ubugmth2;

interface

(*
There appear to be bugs in:

function InterestPayment(Rate: Extended; Period, NPeriods: Integer; PresentValue,
  FutureValue: Extended; PaymentTime: TPaymentTime): Extended;

function InterestRate(NPeriods: Integer;
  Payment, PresentValue, FutureValue: Extended; PaymentTime: TPaymentTime): Extended;

from the MATH.PAS unit of Delphi 2.01


The functions:

function NumberOfPeriods(Rate, Payment, PresentValue, FutureValue: Extended;
  PaymentTime: TPaymentTime): Extended;

function Payment(Rate: Extended; NPeriods: Integer;
  PresentValue, FutureValue: Extended; PaymentTime: TPaymentTime): Extended;

appear to work fine and are included here to a) provide an example of how
to use these functions since the Delphi help has no examples & b) provide
values that may be used to assist in validating the above to buggy functions.

*)


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Math, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    Label1: TLabel;
    BitBtn2: TBitBtn;
    Label2: TLabel;
    Label3: TLabel;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    Label4: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
var
  R,Pmt,PV,FV: Extended;
  NPmts: Extended;
begin
{Declaration

function NumberOfPeriods(Rate, Payment, PresentValue, FutureValue: Extended;
  PaymentTime: TPaymentTime): Extended;

TPaymentTime = (ptEndOfPeriod, ptStartOfPeriod);

Description

The NumberOfPeriods function computes the number of payment periods required
for an investment of PresentValue to reach a value of FutureValue, while
making regular payments of Payment and accruing interest at the rate of Rate
per compounding period. PaymentTime indicates whether the cash flows occur
at the beginning or end of the period (by entering a value of 1or 0,
respectively).
}
  Pmt := 877.57;
  R := 0.00833333;
  PV := 00000;
  FV := 100000;
  NPmts := NumberOfPeriods(R, Pmt, PV, FV, {ptStartOfPeriod} ptEndOfPeriod );
  Label1.Caption := Format( '%10.2n', [NPmts] );

  { Comment --  Result = -360 OK
  }

end;


procedure TForm1.BitBtn2Click(Sender: TObject);
var
  R,Pmt,PV,FV: Extended;
  NPmts: Integer;
begin
{
Declaration

function Payment(Rate: Extended; NPeriods: Integer;
  PresentValue, FutureValue: Extended; PaymentTime: TPaymentTime): Extended;

Description

The Payment function calculates the fully amortized payment of borrowing
PresentValue dollars at Rate percent per period over NPeriods. It assumes
that interest is paid at the end of each period.

FutureValue is the value that the investment will reach at some point.
PaymentTime indicates whether the cash flows occur at the beginning or
end of the period (enter a value of 1 for the beginning or 0 for the end).

}
  R := 0.00833333; {10.00;}
  NPmts := 360;
  PV := 100000;
  FV := 0.0;
  Pmt := Payment(R, NPmts, PV, FV, {ptStartOfPeriod} ptEndOfPeriod );
  Label2.Caption := Format( '%10.2n', [Pmt] );

  { Comment -- Result = 877.57 OK
  }

end;

procedure TForm1.BitBtn3Click(Sender: TObject);
var
  I,
  R,Pmt,PV,FV: Extended;
  CurrentPmt,
  NPmts: Integer;
begin

{
Declaration

function InterestPayment(Rate: Extended; Period, NPeriods: Integer; PresentValue,
  FutureValue: Extended; PaymentTime: TPaymentTime): Extended;

Description

The InterestPayment function calculates what portion of a loan payment
is interest. Rate represents the fixed periodic interest rate, Period
identifies the payment period, NPeriods is the number of periods of the loan,
PresentValue represents the amount borrowed (the principal), FutureValue is
the future value of the investment, and PaymentTime indicates whether the
cash flows occur at the beginning or end of the period (by entering a value
of 1 or 0, respectively).
}
  R := 0.00833333;
  CurrentPmt := 1;
  NPmts := 360;
  PV := 100000;
  FV := 0;
  I := InterestPayment(R, CurrentPmt, NPmts, PV, FV, {ptStartOfPeriod} ptEndOfPeriod );
  Label3.Caption := Format( '%10.2n', [I] );

  { Comment -- result = 1658.30
      The Payment() function says that the regular payment for a 100,000
      principal balance borrowed for 360 monthly periods at an annual
      rate of 10% (periodic rate of 0.00833333) is $877.57. Given that, how
      can the interest for the first period possibly be 1,658.30?
   }

end;

procedure TForm1.BitBtn4Click(Sender: TObject);
var
  I,
  Pmt,PV,FV: Extended;
  NPmts: Integer;
begin

{
Declaration

function InterestRate(NPeriods: Integer;
  Payment, PresentValue, FutureValue: Extended; PaymentTime: TPaymentTime): Extended;

Description

The InterestRate function calculates the interest rate required in order
for an investment of PresentValue, with periodic payments of Payment,
to be worth FutureValue within NPeriods compounding periods. If
NPeriods represents years, an annual interest rate results; if NPeriods
represents months, a monthly interest rate results, and so on. The
PaymentTime parameter indicates whether the cash flows occur at the
beginning or end of the period (by entering a value of 1or 0, respectively).
}

  NPmts := 12;
  Pmt := 10000;
  PV := 1;
  FV := 100000;
  I := InterestRate( NPmts, Pmt, PV, FV, {ptStartOfPeriod} ptEndOfPeriod );
  Label4.Caption := Format( '%10.2n', [I] );

  { Comment -- the values passed to InterestRate certainly appear to be valid.
  However, the call to this function crashes the application with the following
  error:

  "Project PBUGmth2.exe raised exception class EInvalidArgument with message''."
  }

end;

end.
